/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.exportacion;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Exportacion;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Refrendo
extends ObjetoModeloSucesorValidable<Exportacion>
implements InformacionEditable<Refrendo>,
Importable {
    private static final long serialVersionUID = 6124637383813848133L;
    public static final String C_TIPO_DISTRITO_ADUANERO = "tipoExportacionDe";
    public static final String C_ANIO = "anio";
    public static final String C_TIPO_REGIMEN = "tipoRegimen";
    public static final String C_CORRELATIVO = "correlativo";
    public static final String C_VERIFICADOR = "verificador";
    public static final String C_NUM_DOC_TRANSPORTE = "numeroDocTransporte";
    private static final String CORRELATIVO = "Correlativo";
    private static final String TRANSPORTE = "No. Documento de Transporte ";
    private static final String LETRAS_NUMEROS = "El valor debe ser solo letras y n\u00fameros. ";
    private String numeroDocTransporte;
    private String tipoDistritoAduanero;
    private String descripcionTipoDistrito;
    private String anio;
    private String tipoRegimen;
    private String descripcionTipoRegimen;
    private String correlativo = "0";
    private String verificador;
    private int longitudCorrelativo = 0;
    private boolean flagVerificador;

    protected void inicializar() {
        if (!((Exportacion)this.getPropietario()).isRegimenEcuapass()) {
            this.longitudCorrelativo = 6;
            this.flagVerificador = true;
        } else {
            this.longitudCorrelativo = 8;
            this.flagVerificador = false;
        }
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.getNumeroDocTransporte())) {
            return resultado.fallarValidacion("Debe ingresar el valor de No. Documento de Transporte ");
        }
        if (!Pattern.matches("[a-zA-Z0-9]+", this.getNumeroDocTransporte())) {
            return resultado.fallarValidacion("El valor No. Documento de Transporte El valor debe ser solo letras y n\u00fameros. ");
        }
        if (this.getNumeroDocTransporte().trim().length() < 3 || this.getNumeroDocTransporte().trim().length() > 13) {
            return resultado.fallarValidacion("Debe ingresar m\u00ednimo 3 y m\u00e1ximo 13 caract\u00e9res. No. Documento de Transporte ");
        }
        if (StringUtil.isNullOrEmpty((String)this.getTipoDistritoAduanero())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de Distrito Aduanero");
        }
        if (StringUtil.isNullOrEmpty((String)this.getAnio())) {
            return resultado.fallarValidacion("Debe ingresar el valor de A\u00f1o");
        }
        if (!Pattern.matches("\\d{4}", this.getAnio())) {
            return resultado.fallarValidacion("Debe ingresar un a\u00f1o v\u00e1lido");
        }
        if (Util.getInteger(this.getAnio()) > ((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().get(1)) {
            return resultado.fallarValidacion("El valor A\u00f1o debe ser menor o igual al a\u00f1o del Periodo Declarado");
        }
        if (Util.getInteger(this.getAnio()) < 2000) {
            return resultado.fallarValidacion("El valor A\u00f1o debe ser mayor o igual al a\u00f1o 2000");
        }
        if (StringUtil.isNullOrEmpty((String)this.getTipoRegimen())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de R\u00e9gimen");
        }
        if (StringUtil.isNullOrEmpty((String)this.getCorrelativo())) {
            return resultado.fallarValidacion("Debe ingresar el valor de Correlativo");
        }
        if (!Pattern.matches(String.format("\\d{%s}", String.valueOf(this.longitudCorrelativo)), this.getCorrelativo())) {
            return resultado.fallarValidacion("El valor Correlativo debe tener " + this.longitudCorrelativo + " d\u00edgitos");
        }
        if (!this.validarCorrelativo(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (this.flagVerificador) {
            if (StringUtil.isNullOrEmpty((String)this.getVerificador())) {
                return resultado.fallarValidacion("Debe ingresar el valor de Verificador");
            }
            if (this.procesarAnteriorNumeracionSENAE(this.getTipoDistritoAduanero(), this.getAnio(), this.getTipoRegimen(), this.getCorrelativo()) != Util.getInteger(this.getVerificador()).intValue()) {
                return resultado.fallarValidacion("El Valor Correlativo o el valor verificador informado no es v\u00e1lido.");
            }
        }
        return resultado.pasarValidacion();
    }

    public Refrendo crearCopiaEdicion() {
        Refrendo copia = new Refrendo();
        copia.setTipoDistritoAduanero(this.tipoDistritoAduanero);
        copia.setDescripcionTipoDistrito(this.descripcionTipoDistrito);
        copia.setAnio(this.anio);
        copia.setTipoRegimen(this.tipoRegimen);
        copia.setDescripcionTipoRegimen(this.descripcionTipoRegimen);
        copia.setCorrelativo(this.correlativo);
        copia.setVerificador(this.verificador);
        copia.setNumeroDocTransporte(this.numeroDocTransporte);
        copia.setLongitudCorrelativo(this.longitudCorrelativo);
        copia.setFlagVerificador(this.flagVerificador);
        copia.setPropietario((ObjetoModelo)((Exportacion)this.propietario));
        return copia;
    }

    public void actualizarInformacion(Refrendo copiaEdicion) {
        this.setTipoDistritoAduanero(copiaEdicion.getTipoDistritoAduanero());
        this.setDescripcionTipoDistrito(copiaEdicion.getDescripcionTipoDistrito());
        this.setAnio(copiaEdicion.getAnio());
        this.setTipoRegimen(copiaEdicion.getTipoRegimen());
        this.setDescripcionTipoRegimen(copiaEdicion.getDescripcionTipoRegimen());
        this.setCorrelativo(copiaEdicion.getCorrelativo());
        this.setVerificador(copiaEdicion.getVerificador());
        this.setNumeroDocTransporte(copiaEdicion.getNumeroDocTransporte());
    }

    private ResultadoValidacion validarCorrelativo(ResultadoValidacion resultado) {
        if (this.getCorrelativo().trim().length() > this.longitudCorrelativo) {
            return resultado.fallarValidacion("Debe ingresar hasta " + this.longitudCorrelativo + " caracteres. " + CORRELATIVO);
        }
        return resultado;
    }

    private int procesarAnteriorNumeracionSENAE(String distritoAduanero, String anio, String regimen, String correlativo) {
        int verificadorCalculado = 0;
        verificadorCalculado += Integer.parseInt(distritoAduanero.substring(0, 1)) * 2;
        verificadorCalculado += Integer.parseInt(distritoAduanero.substring(1, 2)) * 3;
        verificadorCalculado += Integer.parseInt(distritoAduanero.substring(2, 3)) * 4;
        verificadorCalculado += Integer.parseInt(anio.substring(2, 3)) * 5;
        verificadorCalculado += Integer.parseInt(anio.substring(3, 4)) * 6;
        verificadorCalculado += Integer.parseInt(regimen.substring(0, 1)) * 7;
        verificadorCalculado += Integer.parseInt(regimen.substring(1, 2)) * 8;
        verificadorCalculado += Integer.parseInt(correlativo.substring(0, 1)) * 9;
        verificadorCalculado += Integer.parseInt(correlativo.substring(1, 2)) * 3;
        verificadorCalculado += Integer.parseInt(correlativo.substring(2, 3)) * 4;
        verificadorCalculado += Integer.parseInt(correlativo.substring(3, 4)) * 5;
        verificadorCalculado += Integer.parseInt(correlativo.substring(4, 5)) * 6;
        verificadorCalculado += Integer.parseInt(correlativo.substring(5, 6)) * 7;
        verificadorCalculado = (verificadorCalculado %= 11) == 10 ? 1 : verificadorCalculado;
        return verificadorCalculado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("docTransp");
        Element eValor = (Element)valorList.item(0);
        this.numeroDocTransporte = eValor.getTextContent();
        valorList = elemento.getElementsByTagName("distAduanero");
        eValor = (Element)valorList.item(0);
        this.tipoDistritoAduanero = eValor.getTextContent().trim();
        this.descripcionTipoDistrito = UtilCatalogosATS.crearInstancia().obtenerDescripcionDistritoAduanero(this.getTipoDistritoAduanero());
        valorList = elemento.getElementsByTagName(C_ANIO);
        eValor = (Element)valorList.item(0);
        this.anio = eValor.getTextContent();
        valorList = elemento.getElementsByTagName("regimen");
        eValor = (Element)valorList.item(0);
        this.tipoRegimen = eValor.getTextContent().trim();
        this.descripcionTipoRegimen = UtilCatalogosATS.crearInstancia().obtenerDescripcionRegimenAduanero(this.getTipoRegimen(), ((Exportacion)this.getPropietario()).isRegimenEcuapass());
        valorList = elemento.getElementsByTagName(C_CORRELATIVO);
        eValor = (Element)valorList.item(0);
        this.correlativo = eValor.getTextContent();
        if (this.flagVerificador) {
            valorList = elemento.getElementsByTagName(C_VERIFICADOR);
            eValor = (Element)valorList.item(0);
            this.verificador = eValor.getTextContent();
        }
        return this;
    }

    public String getTipoDistritoAduanero() {
        return this.tipoDistritoAduanero;
    }

    public String getDescripcionTipoDistrito() {
        return this.descripcionTipoDistrito;
    }

    public String getAnio() {
        return this.anio;
    }

    public String getTipoRegimen() {
        return this.tipoRegimen;
    }

    public String getDescripcionTipoRegimen() {
        return this.descripcionTipoRegimen;
    }

    public String getCorrelativo() {
        return this.correlativo;
    }

    public String getVerificador() {
        return this.verificador;
    }

    public String getNumeroDocTransporte() {
        return this.numeroDocTransporte;
    }

    public void setTipoDistritoAduanero(String tipoDistritoAduanero) {
        String oldValue = this.tipoDistritoAduanero;
        this.tipoDistritoAduanero = tipoDistritoAduanero;
        this.firePropertyChange(C_TIPO_DISTRITO_ADUANERO, oldValue, this.tipoDistritoAduanero);
    }

    public void setDescripcionTipoDistrito(String descripcionTipoDistrito) {
        this.descripcionTipoDistrito = descripcionTipoDistrito;
    }

    public void setAnio(String anio) {
        String oldValue = this.anio;
        this.anio = anio;
        this.firePropertyChange(C_ANIO, oldValue, this.anio);
    }

    public void setTipoRegimen(String tipoRegimen) {
        String oldValue = this.tipoRegimen;
        this.tipoRegimen = tipoRegimen;
        this.firePropertyChange(C_TIPO_REGIMEN, oldValue, this.tipoRegimen);
    }

    public void setDescripcionTipoRegimen(String descripcionTipoRegimen) {
        this.descripcionTipoRegimen = descripcionTipoRegimen;
    }

    public void setCorrelativo(String correlativo) {
        String oldValue = this.correlativo;
        this.correlativo = StringUtil.isNullOrEmpty((String)correlativo) ? correlativo : correlativo.toUpperCase();
        this.firePropertyChange(C_CORRELATIVO, oldValue, this.correlativo);
    }

    public void setVerificador(String verificador) {
        String oldValue = this.verificador;
        this.verificador = StringUtil.isNullOrEmpty((String)verificador) ? verificador : verificador.toUpperCase();
        this.firePropertyChange(C_VERIFICADOR, oldValue, this.verificador);
    }

    public void setNumeroDocTransporte(String numeroDocTransporte) {
        String oldValue = this.numeroDocTransporte;
        this.numeroDocTransporte = StringUtil.isNullOrEmpty((String)numeroDocTransporte) ? numeroDocTransporte : numeroDocTransporte.toUpperCase();
        this.firePropertyChange(C_NUM_DOC_TRANSPORTE, oldValue, this.numeroDocTransporte);
    }

    public void setLongitudCorrelativo(int longitudCorrelativo) {
        this.longitudCorrelativo = longitudCorrelativo;
    }

    public void setFlagVerificador(boolean flagVerificador) {
        this.flagVerificador = flagVerificador;
    }

    public boolean getFlagVerificador() {
        return this.flagVerificador;
    }

    public String toString() {
        if (StringUtil.isNullOrEmpty((String)this.getNumeroDocTransporte())) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.tipoDistritoAduanero);
        builder.append("-");
        builder.append(this.anio);
        builder.append("-");
        builder.append(this.tipoRegimen);
        builder.append("-");
        builder.append(this.correlativo);
        builder.append(this.verificador != null ? "-" + this.verificador : "");
        return builder.toString();
    }
}

